//
//  File        : test32.cpp
//  Description : test the 32-bit addZIP Compression Libraries
//
//  Copyright  1996 Stephen Darlington. All rights reserved.
//
//  You have a royalty-free right to use, modify, reproduce and
//  distribute this (and any other) example file (or any modified
//  version) in any way you find useful, provided that you agree
//  that Stephen Darlington has no warranty obligations or liability.

#include <windows.h>
#include <io.h>
#include "addzip.h"
#include "addunzip.h"
#include "ntfy_box.h"

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow) {
	char *cTitle = "Test for 32-bit addZIP Compression Library";
	char cMessage[1000];
	char *cArchive = "TEST32.ZIP";
	char cFiles[256];
	char cWinDir[256];
	short iReturn;

	GetWindowsDirectory((LPSTR)cWinDir, sizeof(cWinDir));

	wsprintf(cMessage, "This is a simple test for the 32-bit addZIP Compression Libraries. \
Please follow the on-screen prompts.\n\nDo you wish to proceed?");
	if (MessageBox(NULL, cMessage, cTitle, MB_YESNO) != IDYES) return 0;
//
// STEP 1 - adding files
//
	wsprintf(cFiles, "%s\\*.INI", cWinDir);
	wsprintf(cMessage, "Step 1: adding %s to %s.\n\nThis will use the default compression \
(COMPRESSION_NORMAL), save full path information (SAVE_ABSOLUTE_PATH) and query the user \
if the file already exists in the archive (OVERWRITE_QUERY).\n\nDo you wish to proceed?", cFiles, cArchive);
	if (MessageBox(NULL, cMessage, cTitle, MB_YESNO) != IDYES) return 0;

	wsprintf(cMessage, "Compressing %s to %s ...", cFiles, cArchive);
	NotifyBox(NULL, cMessage, cTitle, hInstance);
	addZIP_ArchiveName(cArchive);
	// the following are commented out because they are redundant when using the
	// default values
	//addZIP_Overwrite(OVERWRITE_QUERY);
	//addZIP_SetCompressionLevel(COMPRESSION_NORMAL);
	//addZIP_SaveStructure(SAVE_ABSOLUTE_PATH);
	addZIP_Include(cFiles);
	iReturn = addZIP();
	NotifyBox(NULL, NULL, NULL, NULL);
	wsprintf(cMessage, "%i files matching %s successfully compressed to %s. \
You may want to examine the .ZIP archive at this point, or click OK to proceed.",
	iReturn, cFiles, cArchive);
	MessageBox(NULL, cMessage, cTitle, MB_OK);
//
// STEP 2
//
	wsprintf(cFiles, "%s\\*.BMP", cWinDir);
	wsprintf(cMessage, "Step 2: adding %s to %s.\n\nThis will use the maximum compression \
(COMPRESSION_MAXIMUM), save no path information (SAVE_FILENAME_ONLY) and query the user \
if the file already exists in the archive (OVERWRITE_QUERY).\n\nDo you wish to proceed?", cFiles, cArchive);
	if (MessageBox(NULL, cMessage, cTitle, MB_YESNO) != IDYES) return 0;
	wsprintf(cMessage, "Compressing %s to %s ...", cFiles, cArchive);
	NotifyBox(NULL, cMessage, cTitle, hInstance);
	addZIP_ArchiveName(cArchive);
	//addZIP_Overwrite(OVERWRITE_QUERY);
	addZIP_SetCompressionLevel(azCOMPRESSION_MAXIMUM);
	addZIP_SaveStructure(azSTRUCTURE_NONE);
	addZIP_Include(cFiles);
	iReturn = addZIP();
	NotifyBox(NULL, NULL, NULL, NULL);
	wsprintf(cMessage, "%i files matching %s successfully compressed to %s. \
You may want to examine the .ZIP archive at this point, or click OK to proceed.",
	iReturn, cFiles, cArchive);
	MessageBox(NULL, cMessage, cTitle, MB_OK);
//
// STEP 3 - deleting files
//
	wsprintf(cFiles, "%s\\*.INI", cWinDir);
	wsprintf(cMessage, "Step 3: deleting %s from %s.\n\nThis will remove only those files \
matching %s and will ignore files that match *.INI.\n\nDo you wish to proceed?", cFiles, cArchive, cFiles);
	if (MessageBox(NULL, cMessage, cTitle, MB_YESNO) != IDYES) return 0;
	wsprintf(cMessage, "Deleting %s from %s ...", cFiles, cArchive);
	NotifyBox(NULL, cMessage, cTitle, hInstance);
	addZIP_ArchiveName(cArchive);
	addZIP_Include(cFiles);
	addZIP_Delete(TRUE);
	iReturn = addZIP();
	NotifyBox(NULL, NULL, NULL, NULL);
	wsprintf(cMessage, "%i files matching %s successfully deleted from %s. \
You may want to examine the .ZIP archive at this point, or click OK to proceed.",
	iReturn, cFiles, cArchive);
	MessageBox(NULL, cMessage, cTitle, MB_OK);
//
// STEP 4 - extracting files
//
	wsprintf(cMessage, "Step 4: extracting all files from %s.\n\nThis step will decompress all \
the files from the .ZIP archive to the C:\\TEMP directory (which will be created if it \
does not already exist). All stored path information will be ignored.\
\n\nDo you wish to proceed?", cArchive);
	if (MessageBox(NULL, cMessage, cTitle, MB_YESNO) != IDYES) return 0;
	wsprintf(cMessage, "Extracting *.* from %s ...", cArchive);
	NotifyBox(NULL, cMessage, cTitle, hInstance);
	addUNZIP_ArchiveName(cArchive);
	addUNZIP_Include("*.*");
	addUNZIP_ExtractTo("c:\\temp");
	iReturn = addUNZIP();
	NotifyBox(NULL, NULL, NULL, NULL);
	wsprintf(cMessage, "%i files successfully extracted to C:\\TEMP.\n\n\
This ends the test of the addZIP Compression Libraries. The archive %s will be deleted when \
you click OK.", iReturn, cArchive);
	MessageBox(NULL, cMessage, cTitle, MB_OK);
	unlink(cArchive);
	return 0;
}
